class KeyDisplay

  attr_accessor :item_graphic
  def initialize(args, key, item_graphic)
    @font = args.state.text_font
    @args = args
    @display_background = "sprites/item_display.png"

    @item_graphic = item_graphic

    @key_text = key
    @rt_name = "#{key}_display".to_sym
    @w = 75
    @h = 58
  end

  def tick(args)
    @args = args
  end

  def draw(args)
    args.outputs[@rt_name].transient!
    args.outputs[@rt_name].w = @w
    args.outputs[@rt_name].h = @h

    output = [
      {x: 0, y: 10, w: 48, h: 48, path: @display_background, primitive_marker: :sprite},
      {x: 14, y: 0, w: 15, h: 20, primitive_marker: :solid}.merge(Color::WHITE),
      {x: 22, y: 18, text: @key_text, alignment_enum: 1, primitive_marker: :label }.merge(Color::BLACK),
      # {x: 0, y: 0, w: 48, h: 58, primitive_marker: :border}.merge(Color::YELLOW),
    ]

    # if @item_graphic
    #   output << { x: 14, y: 20, w: 32, h: 32, path: @item_graphic, primitive_marker: :sprite }
    # end

    args.outputs[@rt_name].primitives << output

    {w: @w, h: @h, path: @rt_name, primitive_marker: :sprite}
  end
end